﻿using System.Windows;
using System.Windows.Controls;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;

//====================================================
// Описание работы классов и методов исходника на:
// https://www.interestprograms.ru
// Исходные коды программ и игр
//====================================================

namespace WpfHappyNewYear
{
	class AnimationObject
	{
		/// <summary>
		/// Собственное событие завершения анимации объектом данного класса.
		/// </summary>
		public delegate void CompletedEventHandler();
		public event CompletedEventHandler? CompletedEvent;

		/// <summary>
		/// Массив кадров анимации
		/// </summary>
		readonly string[] uriSources = {
			//"img/frame0.png",
			"img/frame1.png",
			"img/frame2.png",
			"img/frame3.png",
			"img/frame4.png",
			"img/frame5.png",
			"img/frame6.png",
			"img/frame7.png"
		};

		/// <summary>
		/// Контейнер для объекта изображения
		/// </summary>
		private readonly Panel? _parent = null;

		private readonly Image image;

		public AnimationObject(Panel parent)
		{
			_parent = parent;

			// Инициализация объекта изображения.
			image = new()
			{
				Margin = new Thickness(0, 0, 0, 0),
				HorizontalAlignment = HorizontalAlignment.Left,
				VerticalAlignment = VerticalAlignment.Top,
				Stretch = System.Windows.Media.Stretch.Fill,
				Visibility = Visibility.Visible
			};

			// Добавляем изображение-экран на главную панель окна программы.
			_parent.Children.Add(image);
		}


		public void Animation()
		{
			// Количество кадров
			int numberFrames = uriSources.Length;

			// Создание объекта управления кадрами анимации
			ObjectAnimationUsingKeyFrames objectAnimation = new()
			{
				// Общее время анимации
				Duration = new Duration(TimeSpan.FromSeconds(4)),
				AutoReverse = true,
				FillBehavior = FillBehavior.Stop
			};

			// Подключение обработчика события завершения анимации кадров.
			objectAnimation.Completed += (sender, e) =>
			{
				
				CompletedEvent?.Invoke();
			};

			// Добавление кадров анимации с одинаковым временем показа.
			for (int i = 0; i < numberFrames - 2; i++)
			{
				objectAnimation.KeyFrames.Add(
					new DiscreteObjectKeyFrame()
					{
						Value = new BitmapImage(new Uri(uriSources[i], UriKind.Relative)),
						KeyTime = KeyTime.FromPercent(0.1 * i),
					}
				);
			}

			objectAnimation.KeyFrames.Add(
				new DiscreteObjectKeyFrame()
				{
					Value = new BitmapImage(new Uri(uriSources[numberFrames - 2], UriKind.Relative)),
					KeyTime = KeyTime.FromPercent(0.6),
				}
			);

			objectAnimation.KeyFrames.Add(
				new DiscreteObjectKeyFrame()
				{
					Value = new BitmapImage(new Uri(uriSources[numberFrames - 1], UriKind.Relative)),
					KeyTime = KeyTime.FromPercent(0.75),
				}
			);


			// Запуск однократной анимации
			image.BeginAnimation(Image.SourceProperty, objectAnimation);
		}

	}
}
