﻿using Android.App;
using Android.Graphics;
using Android.OS;
using Android.Runtime;
using Android.Support.V7.App;
using Android.Views;
using Android.Widget;
using System;
using System.Linq;


//====================================================
// Описание работы классов и методов исходника на:
// www.interestprograms.ru
// Исходные коды программ и игр
// Автор исходных кодов Клочков Павел
//====================================================



namespace AndroidMosaic
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true, ScreenOrientation = Android.Content.PM.ScreenOrientation.Portrait)]
    public class MainActivity : AppCompatActivity
    {
        // Переменные для фиксации положения картинки 
        // при перемещении пальцем.
        private float DeltaX;
        private float DeltaY;

        // Координаты мест расположения картинок в пространстве экрана.
        private RectF[] RectPositionImages;

        // Количество позиций по горизонтали (наименьшему размеру экрана).
        readonly private int NumberRectHorizontal = 9;




        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);




            RelativeLayout layoutMain = this.FindViewById<RelativeLayout>(Resource.Id.LayoutMain);

            // Добавляем в поток интерфейса асинхронную задачу прорисовки
            // картинок только после получения действительных 
            // размеров главного макета-контейнера.
            // Задача исполнится после готовности
            // пользовательского интерфейса.
            layoutMain.Post(() =>
                {
                    ComputePos(layoutMain);
                    
                    ShufflePositions();

                    InitImages(layoutMain);  
                }
            );

            

        }

        // Вычисление позиций и размеров квадратиков
        void ComputePos(RelativeLayout layoutMain)
        {
            int widthLayout = layoutMain.Width;
            int heightLayout = layoutMain.Height;


            // Размер картинок высчитывается точно для горизонтали, 
            // чтобы гармонично смотрелось по ширине.
            int widthRect = widthLayout / NumberRectHorizontal;


            // Картинка квадратная.
            int heightRect = widthRect;


            // Количество строк до заполнения контейнера по высоте.
            int numberRectVertical = heightLayout / heightRect;


            // Все позиции в пространстве.
            RectPositionImages = new RectF[NumberRectHorizontal * numberRectVertical];


            // Расчет позиций в пространстве.
            int countPosY = 0;
            int countPosX = 0;
            for (int i = 0; i < RectPositionImages.Length; i++)
            {
                var rect = new RectF
                {
                    Left = widthRect * countPosX,
                    Top = widthRect * countPosY,
                };
                rect.Right = rect.Left + widthRect;
                rect.Bottom = rect.Top + heightRect;

                RectPositionImages[i] = rect;

                if (countPosX > 0 && countPosX % (NumberRectHorizontal - 1) == 0)
                {
                    countPosX = -1;
                    countPosY++;
                }
                countPosX++;
            }


        }


        // Перемешивание позиций
        private void ShufflePositions()
        {
            RelativeLayout layoutMain = this.FindViewById<RelativeLayout>(Resource.Id.LayoutMain);

            // Перемешивание позиций для случайного начального узора.
            Random rnd = new Random();

            // Лаконичный (кракткий и ясный) перемешивания массива.
            // Сортировка элементов массива по псевдослучайным числам.
            RectPositionImages = RectPositionImages.OrderBy(x => rnd.Next()).ToArray();

            // Второй способ перемешивания (классический).
            //for (int i = 0; i < RectPositionImages.Length; i++)
            //{
            //    int r = rnd.Next(0, RectPositionImages.Length);
            //    RectF temp = RectPositionImages[i];
            //    RectPositionImages[i] = RectPositionImages[r];
            //    RectPositionImages[r] = temp;
            //}
        }


        private void InitImages(RelativeLayout layoutMain)
        {
            // Главный контейнер
            //RelativeLayout layoutMain = this.FindViewById<RelativeLayout>(Resource.Id.LayoutMain);

            // Удалим картинки которые были нужны только для визуализации в дизайнере.
            layoutMain.RemoveAllViews();


            int[] picture = { Resource.Drawable.white, Resource.Drawable.green, Resource.Drawable.blue,
                 Resource.Drawable.red,  Resource.Drawable.white, Resource.Drawable.white,
                Resource.Drawable.white,  Resource.Drawable.yellow, Resource.Drawable.white};


            int countPicture = 0;
            for (int i = 0; i < RectPositionImages.Length; i++)
            {
                var iv = new ImageView(this);
                iv.Touch += ImageView_Touch;
                layoutMain.AddView(iv);


                // Позиция картинки на экране.
                iv.SetX(RectPositionImages[i].Left);
                iv.SetY(RectPositionImages[i].Top);
                iv.LayoutParameters.Width = (int)RectPositionImages[i].Width();
                iv.LayoutParameters.Height = (int)RectPositionImages[i].Height();


                // Запомним назначенную позицию картинки в собственном классе.
                // Картинка сама будет носителем информации о своих позициях.
                var pos = new Positions
                {
                    Position = RectPositionImages[i]
                };

                iv.Tag = pos;


                iv.SetImageResource(picture[countPicture]);

                countPicture++;
                if (countPicture == picture.Length) countPicture = 0;
            }

        }



        private void ImageView_Touch(object sender, View.TouchEventArgs e)
        {

            // Координаты курсора
            MotionEvent motionEvent = e.Event;


            // Принимаем абсолютные координаты курсора.
            float cursorX = motionEvent.RawX;
            float cursorY = motionEvent.RawY;


            // Главный макет для доступа ко всем картинкам.
            RelativeLayout layoutMain = this.FindViewById<RelativeLayout>(Resource.Id.LayoutMain);



            // Активная картинка
            ImageView ivSender = (ImageView)sender;


            // Позиции активной картинки в пространстве экрана
            Positions posSender = (Positions)ivSender.Tag;


            // Центр картинки сделаем посередине, чтобы её 
            // было видно из-под пальца.
            ivSender.PivotX = ivSender.Width / 2;
            ivSender.PivotY = ivSender.Height / 2;



            // Прикасаемся, т.е. нажимаем.
            if (motionEvent.Action == MotionEventActions.Down)
            {

                // Увеличиваем активную картинку для удобного
                // вождения пальцем.
                ivSender.ScaleX = 2.0f;
                ivSender.ScaleY = 2.0f;

                // Делаем картинку полупрозрачной, чтобы было видно 
                // картинки под ней.
                ivSender.Alpha = 0.5f;

                // Поднимаем над всеми.
                ivSender.BringToFront();



                // Запоминаем данную позицию активной картинки.
                posSender.Position = new RectF
                {
                    Left = ivSender.GetX(),
                    Top = ivSender.GetY(),
                    Right = ivSender.GetX() + ivSender.Width,
                    Bottom = ivSender.GetY() + ivSender.Height

                };


                // Постоянная дельта на время вождения картинки.
                // Дельта это разница между координатным положением 
                // картинки по данной оси и местом соприкосновения пальца.
                // Измеряется в абсолютных единицах.
                // Расстояние от места прикосновения до начала координат активной картинки.
                DeltaX = cursorX - ivSender.GetX();
                DeltaY = cursorY - ivSender.GetY();
            }



            // Перемещение активной картинки в поисках места для создания узора.
            if (motionEvent.Action == MotionEventActions.Move)
            {
                // Из координат курсора, во время перемещения, вычитаем расстояние от места прикосновения
                // до начала координат выбранной картинки.
                // Благодаря этому картинка относительно пальца будет неподвижна,
                // и будет двигаться точно под пальцем.
                ivSender.SetX(cursorX - DeltaX);
                ivSender.SetY(cursorY - DeltaY);

                // Отлавливаем место возможного отпускания картинки.
                for (int i = 0; i < RectPositionImages.Length; i++)
                {
                    if (ivSender.GetX() < (RectPositionImages[i].Left + 30) &&
                        ivSender.GetX() > (RectPositionImages[i].Left - 30) &&
                        ivSender.GetY() < (RectPositionImages[i].Top + 30) &&
                        ivSender.GetY() > (RectPositionImages[i].Top - 30))
                    {
                        // Если место найдено просигналим изменением цвета 
                        // передвигаемой картинки.
                        ivSender.SetColorFilter(Color.DarkViolet);

                        // Устанавливаем флаг место найдено.
                        posSender.isFoundPos = true;


                        // Запоминаем новую позицию для активной картинки.
                        posSender.newPos = RectPositionImages[i];

                        break;
                    }

                    // Если отдалились от места возможного приземления
                    // снимаем цветовую сигнализацию перемещаемой картикни.
                    ivSender.ClearColorFilter();

                    // Снимаем флаг обнаружения места приземления.
                    posSender.isFoundPos = false;
                }
            }


            // Поднимаем палец.
            if (motionEvent.Action == MotionEventActions.Up)
            {

                // Возвращаем картинке нормальный масштаб.
                ivSender.ScaleX = 1;
                ivSender.ScaleY = 1;

                // Восстанавливаем непрозрачность.
                ivSender.Alpha = 1.0f;

                // Отпуская курсор принимаем новые координаты для данной картинки.
                // А картинка которая была уже на этой позиции отправляется на прежнее
                // место активной картинки.
                if (posSender.isFoundPos == true)
                {

                    // Извлекаем информацию о нижележащей картинке под перемещаемой.
                    for (int img = 0; img < layoutMain.ChildCount; img++)
                    {
                        ImageView imageView = (ImageView)layoutMain.GetChildAt(img);

                        if (imageView.GetX() == posSender.newPos.Left && imageView.GetY() == posSender.newPos.Top)
                        {
                            // --- Если картинку нашли ---

                            // Поднимаем её над всеми картинками.
                            imageView.BringToFront();

                            // Перемещаем с анимацией картинку на старое место передвигаемой картинки.
                            imageView.Animate().TranslationX(posSender.Position.Left);
                            imageView.Animate().TranslationY(posSender.Position.Top);

                            break;
                        }
                    }

                    // Активная картинка устанавливается на новое место.
                    ivSender.Animate().TranslationX(posSender.newPos.Left);
                    ivSender.Animate().TranslationY(posSender.newPos.Top);

                    // Сбрасываем флаг найденного места.
                    posSender.isFoundPos = false;

                    // Восстанавливаем настоящий цвет.
                    ivSender.ClearColorFilter();
                }
                else
                {
                    // Если нижележащая картинка не найдена,
                    // возвращаем активную картинку на прежнее место.
                    ivSender.Animate().TranslationX(posSender.Position.Left);
                    ivSender.Animate().TranslationY(posSender.Position.Top);

                    // Восстанавливаем настоящий цвет.
                    ivSender.ClearColorFilter();
                }
            }

        }




        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Android.Content.PM.Permission[] grantResults)
        {
            Xamarin.Essentials.Platform.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
        }


    }

    // Собственный класс обязательно наследуем от Java.Lang.Object
    // иначе свойству элементов Tag не сможем
    // присвоить объект класса.
    class Positions : Java.Lang.Object
    {
        // Текущая позиция
        public RectF Position;

        // Новая позиция
        public RectF newPos;

        // Флаг обнаружения места приземления.
        public bool isFoundPos;
    }
}